/*

Rando.C (C) Copyright Bill Buckels 1990-2008.
All rights reserved.

Written by   : Bill Buckels
Email        : bbuckels@mts.net

Date Written : May 2008

Environment  : Apple33 Manx Aztec C65 Version 3.2b
Windows XP Cross-development environment for DOS33

I have made absolutely no attempt to make this program
compatible with any C compiler outside the Apple33
environment stated above.

Purpose      : Children's Activity

Description
-----------

Young childrens' letter recognition game

Although this is a complete rewrite, and basic redesign,
it was only finished to a point that I consider
reasonably functional. Please do not hold this source up
as an example of the way we should work, because there
is much room left to finish this program off if life was
endless, although functionally everything is working as
far as I know.

The important thing is to get it out there for the
kiddies to use. That includes the older kiddies as well,
meaning the rest of us.

Please refer to the ReadMe.txt for Rando for a complete
description and user documentation.

Licence Agreement
-----------------

All my work is copyrighted and belongs to me. This
program is not derived from anything by anyone and is my
own work in its entirety.

I herewith grant you a non-exclusive and conditional
licence to use this source code and the output files it
produces for whatever use you deem fit, provided you do
not take credit for my work, and that you leave my
copyright notices intact in all of it.

If you augment or otherwise use my work you must always
also include your own personal copyright notice but it
may never be a GNU public licence or anything else that
resembles fascism or totalitarianism and world-domination
or a commercial or educational licence either. You can
use my stuff commercially or for GNU with my conditions
intact if they let you (they should since copyright is
for authors and the public and I belong to both groups)
but you must never copyright my work with any company
copyright whatsoever; just your own personal copyright
like mine and leave mine in place. That is the way
copyright is intended to work and that is the way that it
will work with my stuff unless I selectively decide
otherwise.

In addition you must agree that I am not liable in any
way shape or form for any damage from the use of any of
this in any way whatsoever.

If you do not agree with all of the aforementioned
conditions of use or if your use is not Fair then remove
all of this from your computer now.

Bill Buckels
bbuckels@mts.net
May 2008

*/

#include <console.h>

#define bronx() sound(0,0,3)
#define happy() sound(3,0,1)

extern int textbase[];

char *title= "RANDO";
char *tit1 = "Distributed as FreeWare";
char *tit2 = "   A RANDOM LETTERS RECOGNITION GAME  ";
char *tit3 = "  (C)COPYRIGHT BILL BUCKELS 1990-2008 ";
char *tit4 = "Press Any Key";

char *bye1 = "Written in Aztec C65 Version 3.2b";
char *bye2 = "  Built in Windows XP by Bill Buckels ";
char *bye3 = "         THANKS FOR PLAYING!          ";
char *bye4 = "Apple II Forever! Press Any Key";


char *men1 = "<- LEFT  & UP ARROW    RETURN = SELECT";
char *men2 = "-> RIGHT & DOWN ARROW  ESC    = EXIT  ";


char *nreview = "Review - Numbers Only";
char *lreview = "Review - Letters Only";

char *match = "Match Letters and Numbers";
char *lmatch = "Match Letters Only";

char starsbuf[41];
char star[2];

char tmp40[41];
char tmp1[2];

int mpos = 0;
int mold = 0;

/* row1, col, row2 */
int mcords[6][3] = {
	1,3,9,
	1,17,9,
	1,31,9,
	14,3,22,
	14,13,22,
	14,31,22};

/* big letters for menu */
char *mletters[] = {
	"1",
	"A",
	"z",
	"?",
	"A",
	"X"};

/* captions for menu */
char *mtext[] = {
	"Numbers",
	"Upper",
	"Lower",
	"Match",
	"Paired Match",
	"Exit"};

/* musical array created from file habanera.snd */
/* array structure is octave, note, duration */
char habanera[]={
 1,  2,  6, 1,  9,  2, 2,  5,  2, 7,  0,  2, 1,  9,  2, 7,  0,  2,
 1,  2,  6, 1,  9,  2, 2,  5,  2, 7,  0,  2, 1,  9,  2, 7,  0,  2,
 1,  2,  6, 1,  9,  2, 2,  5,  2, 7,  0,  2, 1,  9,  2, 7,  0,  2,
 1,  2,  6, 1,  9,  2, 4,  2,  4, 4,  1,  4, 4,  0,  6, 4,  0,  2,
 3, 11,  4, 3, 10,  4, 3,  9,  6, 3,  9,  2, 3,  8,  4, 3,  7,  4,
 3,  5,  1, 3,  7,  1, 3,  5,  1, 3,  4,  2, 3,  5,  2, 3,  7,  4,
 3,  5,  4, 3,  4,  8, 4,  2,  4, 4,  1,  4, 4,  0,  6, 4,  0,  2,
 3, 11,  4, 3, 10,  4, 3,  9,  6, 3,  9,  2, 3,  7,  4, 3,  5,  4,
 3,  4,  1, 3,  5,  1, 3,  4,  1, 3,  2,  2, 3,  4,  2, 3,  5,  4,
 3,  4,  4, 3,  2,  8, 4,  2,  4, 4,  1,  4, 4,  0,  6, 4,  0,  2,
 3, 11,  4, 3, 10,  4, 3,  9,  6, 3,  9,  2, 3,  8,  4, 3,  7,  4,
 3,  5,  1, 3,  7,  1, 3,  5,  1, 3,  4,  2, 3,  5,  2, 3,  7,  4,
 3,  5,  4, 3,  4,  8, 4,  2,  4, 4,  1,  4, 4,  0,  6, 4,  0,  2,
 3, 11,  4, 3, 10,  4, 3,  9,  6, 3,  9,  2, 3,  7,  4, 3,  5,  4,
 3,  4,  1, 3,  5,  1, 3,  4,  1, 3,  2,  2, 3,  4,  2, 3,  5,  4,
 3,  4,  4, 3,  2,  6, 3,  9,  2, 3,  2,  4, 3,  4,  4, 3,  6,  6,
 3,  9,  2, 3,  6,  4, 3,  4,  4, 3,  2,  6, 3,  4,  2, 3,  6,  4,
 3,  7,  4, 3,  9,  2, 3,  9,  2, 3,  9,  2, 3,  9,  2, 3, 11,  4,
 3,  9,  4, 3,  7,  6, 3, 11,  2, 3,  4,  4, 3,  6,  4, 3,  7,  6,
 3, 11,  2, 3,  7,  4, 3,  6,  4, 3,  4,  6, 3,  6,  2, 3,  7,  4,
 3,  9,  4, 3, 11,  2, 3, 11,  2, 3, 11,  2, 3, 11,  2, 4,  1,  4,
 3, 11,  4, 3,  9,  6, 3,  9,  2, 4,  2,  4, 4,  4,  4, 4,  6,  6,
 3,  9,  2, 3,  6,  4, 3,  4,  4, 3,  2,  6, 3,  4,  2, 3,  6,  4,
 3,  7,  4, 3,  9,  2, 3,  9,  2, 3,  9,  2, 3,  9,  2, 4,  2, 16,
 4,  1,  1, 4,  2,  1, 4,  1,  1, 3,  7,  6, 3, 11,  2, 4,  4,  4,
 4,  6,  4, 4,  7,  6, 3, 11,  2, 3,  7,  4, 3,  6,  4, 3,  4,  6,
 3,  6,  2, 3,  7,  4, 3,  9,  4, 4,  1,  2, 3, 11,  2, 3,  8,  2,
 3,  9,  2, 4,  6, 18, 4,  4,  1, 4,  6,  1, 4,  4,  1, 4,  2,  4,
 7,  0,  2, 4,  9,  2, 5,  2,  4,
'\xff','\xff','\xff'};

/* white keys - octave note indexes */
/* 26 of em, one for each letter of the alphabet */
char whites[26][2]={
    0,  9,
    0,  11,
    1,  0,
    1,  2,
    1,  4,
    1,  5,
    1,  7,
    1,  9,
    1,  11,
    2,  0,
    2,  2,
    2,  4,
    2,  5,
    2,  7,
    2,  9,
    2,  11,
    3,  0,
    3,  2,
    3,  4,
    3,  5,
    3,  7,
    3,  9,
    3,  11,
    4,  0,
    4,  2,
    4,  4};

main()
{
   int idx;

   starsbuf[40] = 0;
   star[1] = 0;
   for (idx = 0; idx < 40; idx++)starsbuf[idx] = '*';
   star[0] = '*';

   show_title();
   for (;;) {
   		mpos = show_menu();
   		if (mpos > 4)break;
   		switch (mpos) {
			case 0: review('1'); break;
			case 1: review('A'); break;
			case 2: review('a'); break;
			case 3: game('?'); break;
			case 4: game('A'); break;
		}
   }
   goodbye();
scr_apple();
reboot();
}


/* called after the countdown */
int yahoo(onoff)
int onoff;
{
    int row, idx;

    row = 5;

    if (onoff == 1) {
		RatherBigFont("YAHOO",row,0,1,0,2);
	}
	else {
	  tmp40[38] = 0;
	  for (idx = 0; idx < 38; idx++)tmp40[idx] = 32;

	}

    for (idx = 0; idx < 16; idx++) {
		print_text(star,row,0,0,0,1);
    	print_text(star,row,39,0,0,1);
    	if (onoff != 1)print_text(tmp40,row,1,0,0,0);
    	row++;
	}

    return 0;
}

/* countdown before reward */
int countdown(cidx)
int cidx;
{
	int idx, col, row;
	char c, sbuf[3];

	c = '9';

    row = 5;
	if (cidx != 2) {
		cidx = 1;
		col = 17;
	}
	else {
		col = 13;
	}
	sbuf[cidx] = 0;

	for(idx=0;idx<10;idx++) {
	   sbuf[0] = c;
	   if (cidx == 2)sbuf[1] = c;
       RatherBigFont(sbuf,row,col,1,0,2);
       sound(3,(char)idx,2);
       c--;
    }

    return 0;
}


/* review activity */
int review(type)
char type;
{
	int c, show, first, trow, tcol, ctr, row;
	char sbuf[4], tbuf[27], *ptr;
	char octave, note;

    /* clear screen and indicate what
       type of review we are doing */
    scr_clear();


    row = 5;
    if (type == 'A') {
		ptr = (char *)&lreview[0];
		strcpy(sbuf,"ABC");
		for (c = 0; c < 26; c++) tbuf[c] = c + 65;
		tbuf[26] = 0;
	}
    else if (type == 'a') {
		ptr = (char *)&lreview[0];
		strcpy(sbuf,"xyz");
		for (c = 0; c < 26; c++) tbuf[c] = c + 97;
		tbuf[26] = 0;
	}
    else {
		ptr = (char *)&nreview[0];
		for (c = 0; c < 10; c++) tbuf[c] = c + 48;
		tbuf[10] = 0;
		strcpy(sbuf,"123");
		type = '1';
	}
	textbox('*',0,0,22,39,1);
    RatherBigFont(sbuf,row,9,1,0,2);

    trow = 2;
    tcol = ((39 - strlen(ptr)) /2) + 1;
    print_top(ptr,trow,tcol);

    trow = 23;
    tcol = ((39 - strlen(tbuf)) /2) + 1;
    print_top(tbuf,trow,tcol);

    strcpy(sbuf,"   ");
    first = 1;
    ctr = 0;

    happy();

	for (;;) {
       c = mygetch();
       if (c == ESCAPE) break;
       show = 0;
       if (type == 'A') {
		   c = toupper(c);
		   if (c > 64 && c < 91) {
			   show = c - 65;
			   octave = whites[show][0];
			   note = whites[show][1];
			   show = 1;
		   }
	   }
       if (type == 'a') {
		   c = tolower(c);
		   if (c > 96 && c < 123) {
			   show = c - 97;
			   octave = whites[show][0];
			   note = whites[show][1];
			   show = 1;
		   }
	   }
	   if (type == '1') {
		   if (c > 47 && c < 58) {
			   show = c - 48;
			   octave = whites[show][0];
			   note = whites[show][1];
			   show = 1;
		   }

	   }
	   if (show != 0) {
		  if (first == 1) {
		      RatherBigFont(sbuf,row,9,0,0,2);
		      first = 0;
		      sbuf[1] = 0;
		  }
	      ctr++;
	      if (ctr > 9) {
			  countdown(1);
			  yahoo(1);
	          reward();
	          ctr= 0;
	          yahoo(0);
		  }
		  sbuf[0] = c;
	      RatherBigFont(sbuf,row,17,0,0,2);
	      if (octave < 5)octave+=2; /* a little higher note */
          sound(octave,note,2);

	   }
	   else {
	     bronx();
	   }
    }

    return 0;

}

/* game play */
int game(type)
char type;
{
	int c, ch, trow, tcol, ctr;
	int rn, target, hold, cidx, row, col;
	char sbuf[3], tbuf[37], *ptr;

    /* clear screen and indicate what
       type of game we are doing */
    scr_clear();


    for (c = 0; c < 26; c++) tbuf[c] = c + 65;
    tbuf[26] = 0;

    row = 5;
    if (type == '?') {
		ptr = (char *)&match[0];
		strcat(tbuf,"0123456789");
		rn = 36;
		sbuf[1] = 0;
		cidx = 1;
		col = 17;
	}
    else {
		ptr = (char *)&lmatch[0];
		type = 'A';
		rn = 26;
		sbuf[2] = 0;
		cidx = 2;
		col = 13;
	}

	textbox('*',0,0,22,39,1);

    trow = 2;
    tcol = ((39 - strlen(ptr)) /2) + 1;
    print_top(ptr,trow,tcol);

    trow = 23;
    tcol = ((39 - strlen(tbuf)) /2) + 1;
    print_top(tbuf,trow,tcol);

    ctr = 0;

    target = random(rn);
    hold = target;

	if (target < 26) ch = target + 65;
	else ch = (target-26)+48;

	sbuf[0] = ch;
	if (cidx == 2) sbuf[1] = tolower(ch);
	RatherBigFont(sbuf,row,col,0,0,2);
	happy();

	for (;;) {

       c = toupper(mygetch());
       if (c == ESCAPE) break;

       if (c!= ch) {
		   bronx();
	   }
	   else {
		   ctr++;
		   if (ctr > 9) {
				  countdown(cidx);
				  yahoo(1);
				  reward();
				  yahoo(0);
				  ctr = 0;
		   }

		   do {
			   target = random(rn);
		   }while (hold == target);
		   hold = target;

		   if (target < 26) ch = target + 65;
		   else ch = (target-26)+48;

		   sbuf[0] = ch;
		   if (cidx == 2) sbuf[1] = tolower(ch);
		   RatherBigFont(sbuf,row,col,0,0,2);
		   happy();
       }
    }

    return 0;

}

/* helper function */
int textbox(c, r1,c1,r2,c2,reverse)
char c;
int r1, c1, r2, c2, reverse;
{
	int width;
	int row, col;


	width = (c2 - c1) + 1;
	tmp40[width] = 0;

    /* use upper case when reversing,
       we get garbage otherwise */
    if (reverse !=0) c = toupper(c);

	tmp1[0]=c;
	tmp1[1]=0;

	for(col = 0; col < width; col++)tmp40[col]=c;

	if (reverse == 0) {
	   print_top(tmp40,r1,c1);
	   r1++;
	   for (row = r1; row < r2; row++) {
		   print_top(tmp1,row,c1);
		   print_top(tmp1,row,c2);
	   }
	   print_top(tmp40,r2,c1);
	}
	else {
	   poke(50,63);
	   scr_curs(r1,c1);
	   printf(tmp40);
	   r1++;
	   for (row = r1; row < r2; row++) {
	      scr_curs(row,c1); putchar(c);
	      scr_curs(row,c2); putchar(c);

	   }
	   scr_curs(r2,c1);
	   printf(tmp40);
       poke(50,255);
	}
	return 0;

}

/* title screen routine */
int show_title()
{

   int idx;

   scr_clear();
   RatherBigFont(title,3,0,0,0,2);
   print_text(starsbuf,0,0,0,0,1);
   for (idx = 1; idx < 23; idx++) {
        print_text(star,idx,0,0,0,1);
        print_text(star,idx,39,0,0,1);
   }
   print_text(starsbuf,23,0,0,0,1);


   idx = (39 - strlen(tit1))/2;
   print_text(tit1,1,idx,0,0,0);

   poke(50,63);
   scr_curs(19,1);
   printf(tit2);
   scr_curs(20,1);
   printf(tit3);
   poke(50,255);

   idx = (39 - strlen(tit4))/2;
   print_text(tit4,22,idx,0,0,0);

   keyplay(habanera);
}


/* farewell screen */
int goodbye()
{

   int idx;

   scr_clear();
   RatherBigFont(title,3,0,0,0,2);
   print_text(starsbuf,0,0,0,0,1);
   for (idx = 1; idx < 23; idx++) {
        print_text(star,idx,0,0,0,1);
        print_text(star,idx,39,0,0,1);
   }
   print_text(starsbuf,23,0,0,0,1);


   idx = (39 - strlen(bye1))/2;
   print_text(bye1,1,idx,0,0,0);

   scr_curs(18,1);
   printf(bye2);
   poke(50,63);
   scr_curs(20,1);
   printf(bye3);
   poke(50,255);

   idx = (39 - strlen(bye4))/2;
   print_text(bye4,22,idx,0,0,0);

   keyplay(habanera);
}

/* main menu routine */
int show_menu()
{

   int c, idx, row, col, blink, scale;
   char *ptr;

   scr_clear();

   for (idx = 0; idx < 6; idx++) {
	   scale = 1;
	   row = mcords[idx][0];
	   col = mcords[idx][1];
	   ptr = (char *)&mletters[idx][0];
	   blink = (idx == mpos);
	   if (idx == 0 && blink == 1) scale = 'N';
	   if (idx == 3 && blink == 1) scale = 'M';
	   RatherBigFont(ptr,row,col,blink,0,scale);
	   if (idx == 4) {
	     RatherBigFont("z",row,col+7,blink,0,scale);
	   }
	   row = mcords[idx][2];
	   ptr = (char *)&mtext[idx][0];
	   print_top(ptr,row,col);
   }
   mold = mpos;


   print_text(starsbuf,0,0,0,0,1);
   for (idx = 1; idx < 23; idx++) {
	   if (idx == 10 || idx == 13) {
	      print_text(starsbuf,idx,0,0,0,1);
	   }
	   else {
        print_text(star,idx,0,0,0,1);
        if (idx < 10 || idx > 13) {
        	print_text(star,idx,11,0,0,1);
        	print_text(star,idx,28,0,0,1);
		}
        print_text(star,idx,39,0,0,1);
	  }
      if (idx == 11)print_top(men1,idx,1);
      if (idx == 12)print_top(men2,idx,1);
   }
   print_text(starsbuf,23,0,0,0,1);
   happy();


   for (;;) {
	   c = toupper(mygetch());
	   if (c == SPACEBAR || c == ENTERKEY) {
		   break;
	   }
	   if (c == ESCAPE || c == 'X' || c == '6') {
	     bronx();
	     mpos = 5;
	     break;
	   }
	   if (c > '0' && c < '6') {
	     c-=49;
	     mpos = c;
	     mold = c;
	     break;
	   }
	   if (c == 'N') {
	     mpos = 0;
	     mold = 0;
	     break;
	   }
	   if (c == 'A') {
	     mpos = 1;
	     mold = 1;
	     break;
	   }
	   if (c == 'Z') {
	     mpos = 2;
	     mold = 2;
	     break;

	   }
	   if (c == '?' || c == 'M') {
	      mpos = 3;
	      mold = 3;
	      break;
	   }

	   if (c == 'P') {
	      mpos = 4;
	      mold = 4;
	      break;
	   }

	   switch(c) {
		   case RTARROW: mpos++; if (mpos > 5)mpos = 0; break;
		   case LTARROW: mpos--; if (mpos < 0)mpos = 5; break;
		   case DNARROW: mpos+=3; if (mpos > 5)mpos-=6; break;
		   case UPARROW: mpos-=3; if (mpos < 0)mpos+=6; break;

	   }

	   if (mpos != mold) {
		    /* disable old position */
		    idx = mold;
		    scale = 1;
	   		row = mcords[idx][0];
	   		col = mcords[idx][1];
	   		ptr = (char *)&mletters[idx][0];
	   		blink = (idx == mpos);
	   		RatherBigFont(ptr,row,col,blink,0,scale);
	   		if (idx == 4) {
			   RatherBigFont("z",row,col+7,blink,0,scale);
	        }
	   		row = mcords[idx][2];
	   		ptr = (char *)&mtext[idx][0];
	   		print_top(ptr,row,col);
	   		/* enable new position */
		    idx = mpos;
	   		row = mcords[idx][0];
	   		col = mcords[idx][1];
	   		ptr = (char *)&mletters[idx][0];
	   		blink = (idx == mpos);
		    if (idx == 0) scale = 'N';
		    if (idx == 3) scale = 'M';
	   		RatherBigFont(ptr,row,col,blink,0,scale);
	   		if (idx == 4) {
			   RatherBigFont("z",row,col+7,blink,0,scale);
	        }
	   		row = mcords[idx][2];
	   		ptr = (char *)&mtext[idx][0];
	   		print_top(ptr,row,col);
	   		/* reset old position to new position */
	   		mold = mpos;

	   }
	   else bronx();
   }
   return mpos;
}

/* ---------------------------------------------- */
/* A rather big font. 8X8 Bitmapped Font          */
/* used as a mapping basis for text characters    */
/* created by screen scan of IBM-PC standard font */
/* ---------------------------------------------- */
char ramfont[1024] = {
0,0,0,0,0,0,0,0,
126,129,165,129,189,153,129,126,
126,255,219,255,195,231,255,126,
108,254,254,254,124,56,16,0,
16,56,124,254,124,56,16,0,
56,124,56,254,254,124,56,124,
16,16,56,124,254,124,56,124,
0,0,24,60,60,24,0,0,
255,255,231,195,195,231,255,255,
0,60,102,66,66,102,60,0,
255,195,153,189,189,153,195,255,
15,7,15,125,204,204,204,120,
60,102,102,102,60,24,126,24,
63,51,63,48,48,112,240,224,
127,99,127,99,99,103,230,192,
153,90,60,231,231,60,90,153,
128,224,248,254,248,224,128,0,
2,14,62,254,62,14,2,0,
24,60,126,24,24,126,60,24,
102,102,102,102,102,0,102,0,
127,219,219,123,27,27,27,0,
62,99,56,108,108,56,204,120,
0,0,0,0,126,126,126,0,
24,60,126,24,126,60,24,255,
24,60,126,24,24,24,24,0,
24,24,24,24,126,60,24,0,
0,24,12,254,12,24,0,0,
0,48,96,254,96,48,0,0,
0,0,192,192,192,254,0,0,
0,36,102,255,102,36,0,0,
0,24,60,126,255,255,0,0,
0,255,255,126,60,24,0,0,
0,0,0,0,0,0,0,0,
48,120,120,120,48,0,48,0,
108,108,108,0,0,0,0,0,
108,108,254,108,254,108,108,0,
48,124,192,120,12,248,48,0,
0,198,204,24,48,102,198,0,
56,108,56,118,220,204,118,0,
96,96,192,0,0,0,0,0,
24,48,96,96,96,48,24,0,
96,48,24,24,24,48,96,0,
0,102,60,255,60,102,0,0,
0,48,48,252,48,48,0,0,
0,0,0,0,0,48,48,96,
0,0,0,252,0,0,0,0,
0,0,0,0,0,48,48,0,
6,12,24,48,96,192,128,0,
124,198,206,222,246,230,124,0,
48,112,48,48,48,48,252,0,
120,204,12,56,96,204,252,0,
120,204,12,56,12,204,120,0,
28,60,108,204,254,12,30,0,
252,192,248,12,12,204,120,0,
56,96,192,248,204,204,120,0,
252,204,12,24,48,48,48,0,
120,204,204,120,204,204,120,0,
120,204,204,124,12,24,112,0,
0,48,48,0,0,48,48,0,
0,48,48,0,0,48,48,96,
24,48,96,192,96,48,24,0,
0,0,252,0,0,252,0,0,
96,48,24,12,24,48,96,0,
120,204,12,24,48,0,48,0,
124,198,222,222,222,192,120,0,
48,120,204,204,252,204,204,0,
252,102,102,124,102,102,252,0,
60,102,192,192,192,102,60,0,
248,108,102,102,102,108,248,0,
126,96,96,120,96,96,126,0,
126,96,96,120,96,96,96,0,
60,102,192,192,206,102,62,0,
204,204,204,252,204,204,204,0,
120,48,48,48,48,48,120,0,
30,12,12,12,204,204,120,0,
230,102,108,120,108,102,230,0,
96,96,96,96,96,96,126,0,
198,238,254,254,214,198,198,0,
198,230,246,222,206,198,198,0,
56,108,198,198,198,108,56,0,
252,102,102,124,96,96,240,0,
120,204,204,204,220,120,28,0,
252,102,102,124,108,102,230,0,
120,204,224,112,28,204,120,0,
252,48,48,48,48,48,48,0,
204,204,204,204,204,204,252,0,
204,204,204,204,204,120,48,0,
198,198,198,214,254,238,198,0,
198,198,108,56,56,108,198,0,
204,204,204,120,48,48,120,0,
254,6,12,24,48,96,254,0,
120,96,96,96,96,96,120,0,
192,96,48,24,12,6,2,0,
120,24,24,24,24,24,120,0,
16,56,108,198,0,0,0,0,
0,0,0,0,0,0,0,255,
48,48,24,0,0,0,0,0,
0,0,120,12,124,204,118,0,
224,96,96,124,102,102,220,0,
0,0,120,204,192,204,120,0,
28,12,12,124,204,204,118,0,
0,0,120,204,252,192,120,0,
56,108,96,240,96,96,240,0,
0,0,118,204,204,124,12,248,
224,96,108,118,102,102,230,0,
48,0,112,48,48,48,120,0,
12,0,12,12,12,204,204,120,
224,96,102,108,120,108,230,0,
112,48,48,48,48,48,120,0,
0,0,204,254,254,214,198,0,
0,0,248,204,204,204,204,0,
0,0,120,204,204,204,120,0,
0,0,220,102,102,124,96,240,
0,0,118,204,204,124,12,30,
0,0,220,118,102,96,240,0,
0,0,124,192,120,12,248,0,
16,48,124,48,48,52,24,0,
0,0,204,204,204,204,118,0,
0,0,204,204,204,120,48,0,
0,0,198,214,254,254,108,0,
0,0,198,108,56,108,198,0,
0,0,204,204,204,124,12,248,
0,0,252,152,48,100,252,0,
28,48,48,224,48,48,28,0,
24,24,24,0,24,24,24,0,
224,48,48,28,48,48,224,0,
118,220,0,0,0,0,0,0,
0,16,56,108,198,198,254,0};

/* the crux of the biscuit */
int msk[]={0x80,0x40,0x20,0x10,0x8,0x4,0x2,0x1};
int RatherBigFont(str,row,col,fg,bg,scale)
char *str;
int row,col,fg,bg,scale;
{
  int target, scanline, offset, r, r2, c, d, e, byte, nibble;
  unsigned char ch, buf[9];

  if (fg != 0)fg = 128;

  if (bg != 0)bg = 128;

  if (scale > 2) {
     e = scale;
     scale = 1;
  }
  else e = 0;

  buf[8]= 0;
  target = strlen(str);
  for(scanline=0;scanline<8;scanline++)
  {

    /* set values for vertical term */
    /* expand x 2 in the vertical direction */
    r = (scanline * scale) + row; /* 16 high */
    if (r > 24)break;
    r2 = r + 1;

    /* run the string 8 times printing a double line
       each time which gives us a font of 16 high*/
    for (byte=0;byte<target;byte++)
     {

      /* calculate the starting column for each
         run in the width of 8 characters */
      c = (byte * 8) + col;
      if (c > 39)continue;

      d = str[byte]&0x7f;
      offset = (d * 8) + scanline;
      ch = ramfont[offset];


      /* allow single character to be used for entire string */
      if (e > 0)d = e&0x7f;

      /* use upper case if blinking */
      if (fg != 0)d = toupper(d);

      /* accumulate 8 characters
         based on the bitmask in the font.
         if whitespace use spaces in the
         background color.
         otherwise build the font with
         the character in the foreground
         color */
      for (nibble=0;nibble<8;nibble++)
       {

        if (ch & msk[nibble]){
          buf[nibble] = d + fg;
        }
        else {
		  buf[nibble] =	32 + bg;

	    }
       }
       print_top(buf, r, c);
       if (r2 < 25 && scale == 2)print_top(buf,r2, c);
    }
  }
  return 0;

}

/* the blue danube waltz -strauss */
/* musical array created from file danube.snd */
/* array structure is octave, note, duration */
char danube[]={
 2,  2,  4, 2,  6,  4, 2,  9,  4, 2,  9,  4, 7,  0,  4, 3,  9,  2,
 7,  0,  2, 3,  9,  2, 7,  0,  6, 3,  6,  2, 7,  0,  2, 3,  6,  2,
 7,  0,  6, 2,  2,  4, 2,  2,  4, 2,  6,  4, 2,  9,  4, 2,  9,  4,
 7,  0,  4, 3,  9,  2, 7,  0,  2, 3,  9,  2, 7,  0,  6, 3,  7,  2,
 7,  0,  2, 3,  7,  2, 7,  0,  6, 2,  1,  4, 2,  1,  4, 2,  4,  4,
 2, 11,  4, 2, 11,  4, 7,  0,  4, 3, 11,  2, 7,  0,  2, 3, 11,  2,
 7,  0,  6, 3,  7,  2, 7,  0,  2, 3,  7,  2, 7,  0,  6, 2,  1,  4,
 2,  1,  4, 2,  4,  4, 2, 11,  4, 2, 11,  4, 7,  0,  4, 3, 11,  2,
 7,  0,  2, 3, 11,  2, 7,  0,  6, 3,  6,  2, 7,  0,  2, 3,  6,  2,
 7,  0,  6, 2,  2,  4, 2,  2,  4, 2,  6,  4, 2,  9,  4, 3,  2,  4,
 7,  0,  4, 4,  2,  2, 7,  0,  2, 4,  2,  2, 7,  0,  6, 3,  9,  2,
 7,  0,  2, 3,  9,  2, 7,  0,  6, 2,  2,  4, 2,  2,  4, 2,  6,  4,
 2,  9,  4, 3,  2,  4, 7,  0,  4, 4,  2,  2, 7,  0,  2, 4,  2,  2,
 7,  0,  6, 3, 11,  2, 7,  0,  2, 3, 11,  2, 7,  0,  6, 2,  4,  4,
 2,  4,  4, 2,  7,  4, 2, 11,  2, 7,  0,  2, 2, 11, 14, 7,  0,  2,
 2,  8,  4, 2,  9,  4, 3,  6, 16, 3,  2,  4, 2,  6,  4, 2,  6,  8,
 2,  4,  4, 2, 11,  8, 2,  9,  4, 2,  2,  4, 7,  0,  2, 2,  2,  2,
 2,  2,  4, 7,  0,  8, 2,  9,  2, 7,  0,  2, 2,  7,  2, 7,  0,  6,
 2,  9,  2, 7,  0,  2, 2,  7,  2, 7,  0,  6, 2,  9,  4, 3,  6, 16,
 3,  4,  4, 2,  9,  2, 7,  0,  2, 2,  6,  2, 7,  0,  6, 2,  9,  2,
 7,  0,  2, 2,  6,  2, 7,  0,  6, 2,  9,  4, 3,  4, 16, 3,  2,  4,
 2,  9,  2, 7,  0,  2, 2,  7,  2, 7,  0,  6, 2,  9,  2, 7,  0,  2,
 2,  7,  2, 7,  0,  6, 2,  9,  4, 3,  6, 16, 3,  4,  4, 2,  9,  4,
 3,  2,  4, 3,  4,  4, 3,  6,  4, 3,  9,  8, 3,  7,  4, 3,  6,  2,
 3,  6,  2, 3,  6,  4, 3,  4,  2, 7,  0,  2, 3,  2,  4, 7,  0,  8,
'\xff','\xff','\xff'};


/* humoresque by dvorak */
/* musical array created from file dvorak.snd */
/* array structure is octave, note, duration */
char dvorak[]={
 2,  7,  3, 7,  0,  2, 2,  9,  1, 2,  7,  3, 7,  0,  2, 2,  9,  1,
 2, 11,  3, 7,  0,  2, 3,  2,  1, 3,  4,  3, 7,  0,  2, 3,  2,  1,
 3,  7,  3, 7,  0,  2, 3,  6,  1, 3,  9,  3, 7,  0,  2, 3,  7,  1,
 3,  6,  3, 7,  0,  2, 3,  9,  1, 3,  7,  3, 7,  0,  2, 3,  4,  1,
 3,  2,  3, 7,  0,  2, 3,  2,  1, 3,  4,  3, 7,  0,  2, 3,  2,  1,
 3,  7,  3, 7,  0,  2, 3,  4,  1, 3,  2,  3, 7,  0,  2, 2, 11,  1,
 2,  9, 24, 2,  7,  3, 7,  0,  2, 2,  9,  1, 2,  7,  3, 7,  0,  2,
 2,  9,  1, 2, 11,  3, 7,  0,  2, 3,  2,  1, 3,  4,  3, 7,  0,  2,
 3,  2,  1, 3,  4,  3, 7,  0,  2, 3,  6,  1, 3,  9,  3, 7,  0,  2,
 3,  7,  1, 3,  6,  3, 7,  0,  2, 3,  9,  1, 3,  7,  3, 7,  0,  2,
 3,  4,  1, 3,  2,  3, 7,  0,  2, 3,  2,  1, 3,  7,  3, 7,  0,  2,
 2,  7,  1, 2,  9,  6, 3,  2,  6, 2,  7, 18,
'\xff','\xff','\xff'};

/* funeral march of a marionette by guonod */
/* musical array created from file guonod.snd */
/* array structure is octave, note, duration */
char guonod[]={
 1,  9,  1, 7,  0,  2, 1,  2,  1, 7,  0,  5, 2,  2,  3, 2,  2,  3,
 2,  1,  3, 1, 11,  3, 2,  1,  3, 7,  0,  3, 2,  2,  3, 2,  4,  3,
 7,  0,  3, 1,  9,  1, 7,  0,  2, 1,  2,  1, 7,  0,  5, 2,  2,  3,
 2,  2,  3, 2,  1,  3, 1, 11,  3, 2,  1,  3, 7,  0,  3, 2,  2,  3,
 2,  4,  3, 7,  0,  3, 1,  9,  3, 2,  2,  3, 7,  0,  3, 2,  5,  3,
 2,  9,  6, 2,  7,  3, 2,  5,  3, 7,  0,  3, 2,  9,  3, 3,  0,  6,
 2, 10,  3, 2,  9,  3, 7,  0,  3, 3,  1,  3, 3,  4,  6, 3,  2,  3,
 3,  1,  3, 2, 10,  3, 2,  9,  3, 2,  7,  3, 2,  5,  3, 2,  4,  3,
 1,  2,  1, 7,  0,  5, 2,  2,  3, 2,  2,  3, 2,  1,  3, 1, 11,  3,
 2,  1,  3, 7,  0,  3, 2,  2,  3, 2,  4,  3, 7,  0,  3, 1,  9,  1,
 7,  0,  2, 1,  2,  1, 7,  0,  5, 2,  2,  3, 2,  2,  3, 2,  1,  3,
 1, 11,  3, 2,  1,  3, 7,  0,  3, 2,  2,  3, 2,  4,  3, 7,  0,  3,
 1,  9,  3, 2,  5,  3, 7,  0,  3, 2,  9,  3, 3,  0,  6, 2, 10,  3,
 2,  9,  3, 2,  7,  3, 2,  5,  3, 2,  3,  3, 2,  7,  3, 2, 10,  3,
 2,  2,  3, 2,  1,  3, 2,  2,  3, 2,  4,  3, 7,  0,  3, 2,  5,  1,
 7,  0,  2, 2,  4,  9, 2,  2,  1,
'\xff','\xff','\xff'};

/* mexican hat dance */
/* musical array created from file mexico.snd */
/* array structure is octave, note, duration */
char mexico[]={
 3,  0,  2, 3,  5,  2, 7,  0,  2, 3,  0,  2, 3,  5,  2, 7,  0,  2,
 3,  0,  2, 3,  5,  6, 7,  0,  4, 3,  0,  2, 3,  5,  2, 3,  7,  2,
 3,  5,  2, 3,  4,  4, 3,  5,  2, 3,  7,  2, 7,  0,  8, 3,  0,  2,
 3,  4,  2, 7,  0,  2, 3,  0,  2, 3,  4,  2, 7,  0,  2, 3,  0,  2,
 3,  4,  6, 7,  0,  4, 3,  0,  2, 3,  4,  2, 3,  5,  2, 3,  4,  2,
 3,  2,  4, 3,  4,  2, 3,  5,  2, 7,  0,  6, 4,  0,  2, 3, 11,  2,
 4,  0,  2, 3,  9,  2, 3,  8,  2, 3,  9,  2, 3,  5,  2, 3,  4,  2,
 3,  5,  2, 3,  0,  2, 7,  0,  4, 2,  9,  2, 2, 10,  2, 3,  0,  2,
 3,  2,  2, 3,  4,  2, 3,  5,  2, 3,  7,  2, 3,  9,  2, 3, 10,  2,
 3,  7,  2, 7,  0,  4, 3, 10,  2, 3,  9,  2, 3, 10,  2, 3,  7,  2,
 3,  6,  2, 3,  7,  2, 3,  4,  2, 3,  3,  2, 3,  4,  2, 3,  0,  2,
 7,  0,  4, 4,  0,  2, 3, 11,  2, 4,  0,  2, 4,  2,  2, 4,  0,  2,
 3, 10,  2, 3,  9,  2, 3,  7,  2, 3,  5,  2,
'\xff','\xff','\xff'};

/* symphony #40 by wolfgang mozart */
/* musical array created from file mozart.snd */
/* array structure is octave, note, duration */
char mozart[]={
 3,  3,  2, 3,  2,  2, 3,  2,  4, 3,  3,  2, 3,  2,  2, 3,  2,  4,
 3,  3,  2, 3,  2,  2, 3,  2,  4, 3, 10,  4, 7,  0,  4, 3, 10,  2,
 3,  9,  2, 3,  7,  4, 3,  7,  2, 3,  5,  2, 3,  3,  4, 3,  3,  2,
 3,  2,  2, 3,  0,  4, 3,  0,  4, 7,  0,  4, 3,  2,  2, 3,  0,  2,
 3,  0,  4, 3,  2,  2, 3,  0,  2, 3,  0,  4, 3,  2,  2, 3,  0,  2,
 3,  0,  4, 3,  9,  4, 7,  0,  4, 3,  9,  2, 3,  7,  2, 3,  6,  4,
 3,  6,  2, 3,  3,  2, 3,  2,  4, 3,  2,  2, 3,  0,  2, 2, 10,  4,
 2, 10,  4, 7,  0,  4, 3, 10,  2, 3,  9,  2, 3,  9,  4, 4,  0,  4,
 3,  6,  4, 3,  9,  4, 3,  7,  4, 3,  2,  4, 7,  0,  4, 3, 10,  2,
 3,  9,  2, 3,  9,  4, 4,  0,  4, 3,  6,  4, 3,  9,  4, 3,  7,  4,
 3, 10,  4, 3,  9,  2, 3,  7,  2, 3,  5,  2, 3,  3,  2, 3,  2,  4,
 2,  6,  4, 2,  7,  4, 2,  9,  4, 2, 10,  4, 3,  0,  2, 2, 10,  2,
 2,  9,  4, 2,  7,  4, 3,  2,  4, 7,  0,  4, 4,  1,  8, 4,  2,  2,
 7,  0,  6, 4,  1,  8, 4,  2,  2, 7,  0,  6, 4,  1,  8, 4,  2,  4,
 4,  1,  4, 4,  2,  4, 4,  1,  4, 4,  2,  4,
'\xff','\xff','\xff'};

/* yankee doodle */
/* musical array created from file sam.snd */
/* array structure is octave, note, duration */
char sam[]={
 3,  0,  3, 7,  0,  1, 3,  0,  3, 7,  0,  1, 3,  2,  3, 7,  0,  1,
 3,  4,  3, 7,  0,  1, 3,  0,  3, 7,  0,  1, 3,  4,  3, 7,  0,  1,
 3,  2,  3, 7,  0,  1, 2,  7,  3, 7,  0,  1, 3,  0,  3, 7,  0,  1,
 3,  0,  3, 7,  0,  1, 3,  2,  3, 7,  0,  1, 3,  4,  3, 7,  0,  1,
 3,  0,  6, 7,  0,  1, 2,  7,  6, 7,  0,  2, 3,  0,  3, 7,  0,  1,
 3,  0,  3, 7,  0,  1, 3,  2,  3, 7,  0,  1, 3,  4,  3, 7,  0,  1,
 3,  5,  3, 7,  0,  1, 3,  4,  3, 7,  0,  1, 3,  2,  3, 7,  0,  1,
 3,  0,  3, 7,  0,  1, 2, 11,  3, 7,  0,  1, 2, 11,  3, 7,  0,  1,
 2,  9,  3, 7,  0,  1, 2, 11,  3, 7,  0,  1, 3,  0,  6, 7,  0,  1,
 3,  0,  6, 7,  0,  3,
'\xff','\xff','\xff'};

/* the stars and stripes forever
   john p. sousa  */
/* musical array created from file stars.snd */
/* array structure is octave, note, duration */
char stars[]={
 3,  2,  6, 3,  2,  6, 3,  0,  3, 2, 11,  3, 2, 11,  6, 2, 10,  3,
 2, 11,  3, 2, 11, 16, 7,  0,  2, 2, 10,  3, 2, 11,  3, 2, 11,  6,
 2, 10,  3, 2, 11,  3, 3,  2,  6, 2, 11,  3, 3,  2,  3, 3,  0, 12,
 2,  9,  6, 7,  0,  3, 2,  9,  3, 2,  9,  6, 2,  8,  3, 2,  9,  3,
 2,  9,  6, 2,  8,  3, 2,  9,  3, 3,  0, 16, 7,  0,  2, 2, 11,  3,
 2,  9,  3, 2, 11,  3, 3,  2,  9, 3,  4,  9, 3,  4,  3, 2,  9, 16,
 7,  0,  2, 3,  2,  6, 3,  2,  6, 3,  0,  3, 2, 11,  3, 2, 11,  6,
 2, 10,  3, 2, 11,  3, 2, 11, 16, 7,  0,  2, 2, 10,  3, 2, 11,  3,
 2, 11,  6, 2, 10,  3, 2, 11,  3, 3,  0,  3, 2, 11,  3, 2,  9,  5,
 2,  6,  1, 2,  9, 12, 2,  7,  6, 7,  0,  3, 2,  7,  3, 2,  7,  6,
 2,  6,  3, 2,  7,  3, 2, 10,  6, 2,  9,  3, 2,  7,  3, 3,  7, 15,
 7,  0,  3, 2,  7,  3, 2,  9,  3, 2, 11,  3, 3,  2,  1, 7,  0,  2,
 2,  7,  3, 2,  9,  3, 2, 11,  3, 3,  2,  1, 7,  0,  2, 2,  2,  3,
 2,  4,  5, 2, 11,  1, 2,  9, 12, 2,  7,  1,
'\xff','\xff','\xff'};


/* archie and mehitabel's lovesong */
/* musical array created from file bug.snd */
/* array structure is octave, note, duration */
char bug[]={
 2,  2,  1, 7,  0,  1, 2,  2,  1, 7,  0,  1, 2,  2,  1, 7,  0,  1,
 2,  7,  1, 7,  0,  5, 2, 11,  1, 7,  0,  3, 2,  2,  1, 7,  0,  1,
 2,  2,  1, 7,  0,  1, 2,  2,  1, 7,  0,  1, 2,  7,  1, 7,  0,  5,
 2, 11,  1, 7,  0,  5, 1,  2,  1, 7,  0,  1, 1,  2,  1, 7,  0,  1,
 1,  7,  1, 7,  0,  3, 2,  7,  1, 7,  0,  1, 2,  7,  1, 7,  0,  1,
 2,  6,  1, 7,  0,  1, 2,  6,  1, 7,  0,  1, 2,  4,  1, 7,  0,  1,
 2,  4,  1, 7,  0,  1, 2,  2,  8, 7,  0,  2, 2,  2,  1, 7,  0,  1,
 2,  2,  1, 7,  0,  1, 2,  2,  1, 7,  0,  1, 2,  6,  1, 7,  0,  5,
 2,  9,  1, 7,  0,  3, 2,  2,  1, 7,  0,  1, 2,  2,  1, 7,  0,  1,
 2,  2,  1, 7,  0,  1, 2,  6,  1, 7,  0,  5, 2,  9,  1, 7,  0,  5,
 1,  9,  1, 7,  0,  1, 1,  9,  1, 7,  0,  1, 1,  2,  1, 7,  0,  3,
 3,  2,  2, 3,  4,  2, 3,  2,  2, 3,  0,  2, 2, 11,  2, 2,  9,  2,
 2,  7,  8,
'\xff','\xff','\xff'};

/* popgoestheweasel */
/* musical array created from file popwease.snd */
/* array structure is octave, note, duration */
char popwease[]={
 3,  2,  5, 7,  0,  1, 3,  2,  2, 7,  0,  1, 3,  4,  5, 7,  0,  1,
 3,  4,  2, 7,  0,  1, 3,  6,  2, 7,  0,  1, 3,  9,  2, 7,  0,  1,
 3,  6,  2, 7,  0,  1, 3,  2,  5, 7,  0,  1, 2,  9,  2, 7,  0,  1,
 3,  2,  5, 7,  0,  1, 3,  2,  2, 7,  0,  1, 3,  4,  5, 7,  0,  1,
 3,  4,  2, 7,  0,  1, 3,  6,  8, 7,  0,  1, 3,  2,  5, 7,  0,  1,
 2,  9,  2, 7,  0,  1, 3,  2,  5, 7,  0,  1, 3,  2,  2, 7,  0,  1,
 3,  4,  5, 7,  0,  1, 3,  4,  2, 7,  0,  1, 3,  6,  2, 7,  0,  1,
 3,  9,  2, 7,  0,  1, 3,  6,  2, 7,  0,  1, 3,  2,  8, 7,  0,  1,
 3, 11,  2, 7,  0,  1, 7,  0,  2, 7,  0,  1, 7,  0,  2, 7,  0,  1,
 3,  4,  5, 7,  0,  1, 3,  7,  2, 7,  0,  1, 3,  6,  8, 7,  0,  1,
 3,  2,  8, 7,  0,  1,
'\xff','\xff','\xff'};


int song_idx = 0;
int reward()
{

      /* this used to be random */
      /* but too many repeats so just plays
         in order now */
      /* choice of 9 songs */
      switch(song_idx)
      {
		  case 0: keyplay(danube); break;
		  case 1: keyplay(dvorak); break;
		  case 2: keyplay(guonod); break;
		  case 3: keyplay(mexico); break;
		  case 4: keyplay(mozart); break;
		  case 5: keyplay(sam); break;
		  case 6: keyplay(stars); break;
		  case 7: keyplay(bug); break;
		  case 8: keyplay(popwease); break;

	  }

	  song_idx++;
	  if (song_idx > 8)song_idx = 0;

return song_idx;
}


/* a simple pseudo random number generator
   this is suitable for game play */
int randomctr=0;
int random(seed)
int seed;
{
	if (randomctr < 32000)randomctr++;
	return randomctr%seed;

}

/* using the keyboard to increment
   the random number base.
   normally a clock value would be used
   but we have no such thing to work with
   and don't need it for this program either */
int mygetch()
{
	int c=getch();

    if (randomctr > 32000)randomctr = 0;
    randomctr+=c;
    randomctr++;

	return c;
}

/* this version of play breaks on a keypress */
int keyplay(song)
char *song;
{

    char octave, note, duration, c = 0, ret = 0;
    int ctr=0;
	/* keypress */
    char *KEYPRESS = (char*)0xC000;
    char *KEYCLEAR = (char*)0xC010;           /* clear the last key press   */

    /* clear stragglers from the keyboard buffer */
    while((c=KEYPRESS[0]) > 127)KEYCLEAR[0]=0;

    while( (octave=song[ctr++])!=255)
    {
      note=song[ctr++];
      duration=song[ctr++];
      if (duration > 0) {
		  sound(octave,note,duration);
          c = KEYPRESS[0];
          if (c > 127) {
			  ret = -1;
			  break;
		  }
	  }
    }

    /* just some more random number base incrementation */
    if (randomctr > 32000)randomctr = 0;
    randomctr += ctr;
    randomctr += c;

    /* clear stragglers from the keyboard buffer */
	while((c=KEYPRESS[0]) > 127)KEYCLEAR[0]=0;


return ret;

}

